/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.TestSectionVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.gui.wizard.TestPage;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;

public class TestSectionPage
extends ActivityCardItemPanel {
    private int currentTestPageIndex;
    private Vector testPages;
    private JPanel currentDisplay;

    TestSectionPage(TestSectionVO testSectionVO, Collection collection) throws Exception {
        this.setLayout(new BorderLayout());
        this.testPages = new Vector(collection.size());
        for (TestVO testVO : collection) {
            this.testPages.add(new TestPage(testVO));
        }
        this.setDisplay();
    }

    public void setDisplay() {
        JPanel jPanel;
        TestPage testPage = this.getCurrentTestPage();
        if (testPage != null && (jPanel = testPage.getDisplayPanel()) != null) {
            if (this.currentDisplay != null) {
                this.remove(this.currentDisplay);
            }
            this.currentDisplay = jPanel;
            this.add((Component)this.currentDisplay, "Center");
            this.updateUI();
        }
    }

    private TestPage getCurrentTestPage() {
        if (this.currentTestPageIndex < 0 || this.currentTestPageIndex > this.testPages.size() - 1) {
            return null;
        }
        return (TestPage)this.testPages.get(this.currentTestPageIndex);
    }

    public boolean isFirstTest() {
        return this.currentTestPageIndex == 0;
    }

    public boolean isLastTest() {
        return this.currentTestPageIndex == this.testPages.size() - 1;
    }

    public boolean isFirstStep() {
        if (this.currentTestPageIndex < 0 || this.currentTestPageIndex > this.testPages.size() - 1) {
            return false;
        }
        return ((TestPage)this.testPages.get(this.currentTestPageIndex)).isFirstStep();
    }

    public boolean isLastStep() {
        if (this.currentTestPageIndex < 0 || this.currentTestPageIndex > this.testPages.size() - 1) {
            return false;
        }
        return ((TestPage)this.testPages.get(this.currentTestPageIndex)).isLastStep();
    }

    public boolean nextButtonAction(ActionEvent actionEvent) {
        boolean bl = true;
        while (bl && !this.isLastStep()) {
            TestPage testPage = this.getCurrentTestPage();
            if (testPage == null) continue;
            testPage.nextButtonAction(actionEvent);
            this.setDisplay();
            testPage = this.getCurrentTestPage();
            bl = testPage != null ? !testPage.isUserFound() : false;
            if (SCTSelection.instance().getAutoStep()) continue;
            bl = false;
        }
        return false;
    }

    public boolean cancelButtonAction(ActionEvent actionEvent) {
        if (this.currentTestPageIndex > 0) {
            --this.currentTestPageIndex;
            TestPage testPage = this.getCurrentTestPage();
            if (testPage != null) {
                testPage.resetTestPage();
                this.setDisplay();
            }
            return false;
        }
        return true;
    }

    public boolean finishButtonAction(ActionEvent actionEvent) {
        if (this.currentTestPageIndex < this.testPages.size() - 1) {
            ++this.currentTestPageIndex;
            TestPage testPage = this.getCurrentTestPage();
            if (testPage != null) {
                testPage.resetTestPage();
                this.setDisplay();
            }
            return false;
        }
        return true;
    }

    public void setFirstIndex() {
        this.currentTestPageIndex = 0;
        this.setDisplay();
    }

    public void setLastIndex() {
        this.currentTestPageIndex = this.testPages.size() - 1;
        this.setDisplay();
    }

    public boolean backButtonAction(ActionEvent actionEvent) {
        TestPage testPage = this.getCurrentTestPage();
        if (testPage != null) {
            testPage.resetTestPage();
            this.setDisplay();
        }
        return false;
    }

    public int getTestCount() {
        return this.testPages.size();
    }

    public int getTestIndex() {
        return this.currentTestPageIndex;
    }
}

